;**********************************************************************
;                                                                     *
;    Filename:	    main.asm                                          *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:        el@jap.hu, http://jap.hu/electronic               *
;    Company:                                                         *
;**********************************************************************
;NOTES
;
; temperature meter
;
;**********************************************************************
;HISTORY
;
;001-20030921 initial: measure temperature and display on 2 digits
;003-20040531 use LCD on 16f871
;   - 1 mA @ 4.5VDC
;**********************************************************************

	list      p=16f871


#include <p16f871.inc>
#include "tc77.inc"

	__CONFIG _CP_OFF & _WDT_OFF & _PWRTE_ON & _XT_OSC & _BODEN_OFF &_LVP_OFF

mainda		UDATA

dly1		res 1
dly2		res 1
dly3		res 1

w_save		res 1 ; itr save
s_save		res 1 ; itr save
f_save		res 1 ; itr save

temp		res 2

tc_tpr		res 2 ; low, high

flags		res 1

digits		res 4 ; 4 x 7-segments to display
segments	res 5 ; physycal LCD segment driver bits
segments_buffer	res 5 ; segments buffer for the interrupt

segments_xor	res 1

		; interrupt segments synchronization
#define INT_SYNC	flags, 0
		; interrupt please read temp
#define TEMP_READ	flags, 1

vectors		CODE 0
  		goto    main		; go to beginning of program
		nop
		nop
		nop
					; interrupt vector location
		goto itr

prog		CODE 5

itr		movwf w_save
		swapf STATUS, W
		movwf s_save
		movf FSR, W
		movwf f_save

		bcf INTCON, T0IF
		call interrupt

		movf f_save, W
		movwf FSR
		swapf s_save, W
		movwf STATUS
		swapf w_save, F
		swapf w_save, W
		retfie

segtable	bcf PCLATH, 0 ; on page 0
		addwf PCL, F
		; segments bit7-bit0:.GFEDCBA
		;
		dt B'00111111', B'00000110' ; 01
		dt B'01011011', B'01001111' ; 23
		dt B'01100110', B'01101101' ; 45
		dt B'01111101', B'00000111' ; 67
		dt B'01111111', B'01101111' ; 89
		dt B'01110111', B'01111100' ; Ab
		dt B'00111001', B'01011110' ; Cd
		dt B'01111001', B'01110001' ; EF

lookup_frac	bcf PCLATH, 0
		addwf PCL, F
		dt 0, 1 ; .0=0; .0625=.1
		dt 1, 2	; .125=.1; .1875=.2
		dt 3, 3 ; .25=.3; .3125=.3
		dt 4, 4 ; .375=.4; .4375=.4
		dt 5, 6 ; .5=.5; .5625=.6
		dt 6, 7 ; .625=.6; .6875=.7
		dt 8, 8 ; .75=.8; .8125=.8
		dt 9, 9 ; .875=.9; .9375=.9

main
		;HARDWARE INIT

		clrf PORTA
		movlw 8 ; -SCS: tc77 chip select
		movwf PORTB
		clrf PORTC
		clrf PORTD
		clrf PORTE

		BANKSEL TRISA
		clrf TRISA
		clrf TRISB
		clrf TRISC
		clrf TRISD
		clrf TRISE

		movlw 6
		movwf ADCON1 ; no analog inputs

		clrwdt ; changing default presc. assignment
		movlw 0x84 ; prescaler 1:32 assigned to TMR0
                           ; pullups disabled
                           ; T0CS selects internal CLK
		movwf OPTION_REG
		BANKSEL PORTA

		call tc77_poweroff
		;call delay_2s
		call tc77_poweroff
		call tc77_poweron

warm
		clrf flags
		clrf digits
		clrf digits+1
		clrf digits+2
		clrf digits+3
		clrf segments_xor

		; init interrupts
		movlw (1<<GIE) + (1<<T0IE)
		movwf INTCON

loop		btfsc INT_SYNC
		goto loop

; obtain temp reading
		bsf TEMP_READ
loop2		btfsc TEMP_READ
		goto loop2

		; adjust difference of
		; tc77_ioread here!

		clrf digits
		movlw digits
		movwf FSR
		bcf STATUS, C
		rlf tc77_ioread, W
		rlf tc77_ioread+1, W ; W is temp in celsius
		call print_dec

		rrf tc77_ioread, W
		movwf digits+3
		rrf digits+3, F
		rrf digits+3, W
		andlw 0x0f ; use original bit6,5,4,3
		call lookup_frac
		call segtable
		movwf digits+3

		call convert_segments
		movlw 1
		call delay_x
		goto loop

print_dec	movwf temp
		clrf temp+1

pr_dec100	movlw	d'100'
		subwf	temp, W
		bnc	pr_dec11

		movwf	temp
		incf	temp+1, F
		goto	pr_dec100

pr_dec11	movf	temp+1, W
		call	print_chr

pr_dec10	movlw	d'10'
		subwf	temp, W
		bnc	pr_dec1

		movwf	temp
		incf	temp+1, F
		goto	pr_dec10

pr_dec1		movf	temp+1, W
		call	print_chr
		movf 	temp, W

print_chr	call segtable
		movwf INDF
		incf FSR, F
		return

convert_segments
		; convert digits into segments
		clrf segments
		clrf segments+1
		clrf segments+2
		clrf segments+3
		clrf segments+4

		btfss digits, 0 ; Z - leading 1
		bsf segments+1, 2 ; RB2

		btfsc digits+1, 0 ; 1A
		bsf segments+3, 6 ; D6

		btfsc digits+1, 1 ; 1B
		bsf segments+3, 5 ; D5

		btfsc digits+1, 2 ; 1C
		bsf segments+4, 0 ; E0

		btfsc digits+1, 3 ; 1D
		bsf segments+1, 1 ; B1

		btfsc digits+1, 4 ; 1E
		bsf segments, 5 ; A5

		btfsc digits+1, 5 ; 1F
		bsf segments+3, 7 ; D7

		btfsc digits+1, 6 ; 1G
		bsf segments+1, 0 ; B0

		btfsc digits+2, 0 ; 2A
		bsf segments+2, 6 ; C6

		btfsc digits+2, 1 ; 2B
		bsf segments+2, 5 ; C5

		btfsc digits+2, 2 ; 2C
		bsf segments+2, 0 ; C0

		btfsc digits+2, 3 ; 2D
		bsf segments+4, 2 ; E2

		btfsc digits+2, 4 ; 2E
		bsf segments+4, 1 ; E1

		btfsc digits+2, 5 ; 2F
		bsf segments+2, 7 ; C7

		btfsc digits+2, 6 ; 2G
		bsf segments+3, 4 ; D4

		btfsc digits+3, 0 ; 3A
		bsf segments+3, 2 ; D2

		btfsc digits+3, 1 ; 3B
		bsf segments+3, 1 ; D1

		btfsc digits+3, 2 ; 3C
		bsf segments+3, 0 ; D0

		btfsc digits+3, 3 ; 3D
		bsf segments+2, 3 ; C3

		btfsc digits+3, 4 ; 3E
		bsf segments+2, 2 ; C2

		btfsc digits+3, 5 ; 3F
		bsf segments+3, 3 ; D3

		btfsc digits+3, 6 ; 3G
		bsf segments+2, 4 ; C4

		; constant ON
		bsf segments+2, 1 ; P3, C1

		; bcf segments+1, 4 ; COM, B4

		; signal for interrupt to update
		bsf INT_SYNC
		return


interrupt	movlw 0xff
		xorwf segments_xor, F

		movf segments_buffer, W
		xorwf segments_xor, W
		movwf PORTA

		movf segments_buffer+1, W
		xorwf segments_xor, W
		iorlw (1 << 3) ; SCS high!
		movwf PORTB

		movf segments_buffer+2, W
		xorwf segments_xor, W
		movwf PORTC

		movf segments_buffer+3, W
		xorwf segments_xor, W
		movwf PORTD

		movf segments_buffer+4, W
		xorwf segments_xor, W
		movwf PORTE

		btfsc TEMP_READ
		call tc77_read
		btfsc TEMP_READ
		call tc77_read
		bcf TEMP_READ

		btfss INT_SYNC
		return

sync_segments	movf segments, W
		movwf segments_buffer
		movf segments+1, W
		movwf segments_buffer+1
		movf segments+2, W
		movwf segments_buffer+2
		movf segments+3, W
		movwf segments_buffer+3
		movf segments+4, W
		movwf segments_buffer+4
		bcf INT_SYNC
		return

delay_2s
		movlw .8
delay_x		movwf dly3
delay3		movlw 0
		movwf dly2
delay2		movlw 0
		movwf dly1
		clrwdt
delay1		nop
		decfsz dly1, F
		goto delay1
		decfsz dly2, F
		goto delay2
		decfsz dly3, F
		goto delay3
		return


		end

