;**********************************************************************
;                                                                     *
;    Filename:	    tc77.asm                                          *
;    Date:                                                            *
;    File Version:                                                    *
;                                                                     *
;    Author:        el@jap.hu                                         *
;    Company:                                                         *
;**********************************************************************
;NOTES
;
; TC77 temperature sensor handler
;
;**********************************************************************
;HISTORY
;
;001-20030316 initial code in sensor3.asm
;002-20030421 library version
;
;**********************************************************************

	list      p=16f871

#include <p16f871.inc>

#define SIOPORT	PORTB
#define SIOTRIS	TRISB

#define SCK 6
#define SIO 7
#define SCS 3

	GLOBAL tc77_ioread
	GLOBAL tc77_poweron, tc77_poweroff, tc77_read

tc77da		UDATA

iocnt		res 1 ; tc_read cycle
tc77_ioread	res 2

tc77code	CODE

tc77_poweron	bsf SIOPORT, SCS ; reset
		bcf SIOPORT, SCS
		BANKSEL SIOTRIS
		bsf SIOTRIS, SIO ; set SIO as input
		BANKSEL SIOPORT

		call tc77_rw ; read 16 bits

		BANKSEL SIOTRIS
		bcf SIOTRIS, SIO ; set SIO as output
		BANKSEL SIOPORT
		bcf SIOPORT, SIO ; set SIO to LOW (enter continous mode)
		call tc77_rw ; write 16 bits of LOW

		BANKSEL SIOTRIS
		bsf SIOTRIS, SIO ; set SIO as input
		BANKSEL SIOPORT

		bsf SIOPORT, SCS
		return

tc77_poweroff	bsf SIOPORT, SCS ; reset
		bcf SIOPORT, SCS
		BANKSEL SIOTRIS
		bsf SIOTRIS, SIO ; set SIO as input
		BANKSEL SIOPORT

		call tc77_rw ; read 16 bits

		BANKSEL SIOTRIS
		bcf SIOTRIS, SIO ; set SIO as output
		BANKSEL SIOPORT
		bsf SIOPORT, SIO ; set SIO to HIGH (shutdown)
		call tc77_rw ; write 16 bits of HIGH

		BANKSEL SIOTRIS
		bsf SIOTRIS, SIO ; set SIO as input
		BANKSEL SIOPORT

		bsf SIOPORT, SCS
		return


tc77_read	bsf SIOPORT, SCS ; reset
		bcf SIOPORT, SCS

		BANKSEL SIOTRIS
		bsf SIOTRIS, SIO ; set SIO as input
		BANKSEL SIOPORT

		clrf tc77_ioread ; LOW
		clrf tc77_ioread+1; HIGH

		call tc77_rw ; read 16 bits

		bsf SIOPORT, SCS
		return


tc77_rw		movlw 0x10
		movwf iocnt
tc77_cycle	bsf SIOPORT, SCK
		bsf STATUS, C
		btfss SIOPORT, SIO
		bcf STATUS, C
		bcf SIOPORT, SCK
		rlf tc77_ioread, F
		rlf tc77_ioread+1, F
		decfsz iocnt, F
		goto tc77_cycle
		return

		end

